import random
import numpy as np
from hypersense.sampler.base_sampler import BaseSampler


class RandomSampler(BaseSampler):
    """
    A simple random sampler that selects a subset of the dataset uniformly at random.
    """

    def sample(self):
        """
        Randomly sample `self.sample_size` elements from the dataset.

        Returns:
            List[Any]: The sampled subset of the dataset.
        """
        random.seed(self.seed)
        np.random.seed(self.seed)

        total_size = len(self.dataset)
        if self.sample_size > total_size:
            raise ValueError(f"Sample size ({self.sample_size}) exceeds dataset size ({total_size}).")

        indices = np.random.choice(total_size, self.sample_size, replace=False)
        return [self.dataset[i] for i in indices]
